//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
// AssemblyPropertiesPage.cpp : plik implementacji
//

#include "stdafx.h"
#include "AssemblyDoc.h"
#include "AssemblyView.h"
#include "AssemblyPropertiesPage.h"


// Okno dialogowe CAssemblyPropertiesPage

IMPLEMENT_DYNAMIC(CAssemblyPropertiesPage, CPropertyPage)
CAssemblyPropertiesPage::CAssemblyPropertiesPage()
	: CPropertyPage(CAssemblyPropertiesPage::IDD)
{
}

CAssemblyPropertiesPage::~CAssemblyPropertiesPage()
{
}

void CAssemblyPropertiesPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAssemblyPropertiesPage, CPropertyPage)
END_MESSAGE_MAP()


// Procedury obsugi wiadomoci CAssemblyPropertiesPage
BOOL CAssemblyPropertiesPage::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// Wypenienie danymi
	CPropertySheet *pPropertySheet = STATIC_DOWNCAST(CPropertySheet, GetParent());
	CAssemblyView* pView = STATIC_DOWNCAST(CAssemblyView, pPropertySheet->GetParent());
	CAssemblyDoc* pDoc = pView->GetDocument();
	IMetaDataImport* pImport  = pDoc->MetaDataImportInterface();

	IMetaDataAssemblyImport *pAssemblyImport;
    HRESULT hr = pImport->QueryInterface(IID_IMetaDataAssemblyImport, (void**) &pAssemblyImport);
    if (FAILED(hr))
	{
        TRACE("Dziaanie QueryInterace dla IID_IMetaDataAssemblyImport nie powiodo si. 0x%0X8\n", hr);
		return FALSE;
	}

    //STDMETHOD(GetAssemblyProps)(            // S_OK lub bd.
    //    mdAssembly  mda,                    // [IN] Podzesp, ktrego waciwoci s pobierane.
    //    const void  **ppbPublicKey,         // [OUT] Wskanik do klucza publicznego.
    //    ULONG       *pcbPublicKey,          // [OUT] Liczba bajtw w kluczu publicznym.
    //    ULONG       *pulHashAlgId,          // [OUT] Algorytm skrtu.
    //    LPWSTR      szName,                 // [OUT] Bufor do wypenienia nazw.
    //    ULONG       cchName,                // [IN] Wielko bufora w znakach.
    //    ULONG       *pchName,               // [OUT] Rzeczywista liczba znakw w nazwie.
    //    ASSEMBLYMETADATA *pMetaData,        // [OUT] Metadane podzespou.
    //    DWORD       *pdwAssemblyFlags) PURE;    // [OUT] Znaczniki.

    mdAssembly      mda;
    const BYTE      *pbPublicKey;
    ULONG           cbPublicKey;
    ULONG           ulHashAlgId;
    WCHAR           szName[STRING_BUFFER_LEN];
    ASSEMBLYMETADATA MetaData;
    DWORD           dwFlags;
	WCHAR			cBuffer[1024];
	WCHAR			tBuffer[16];

    hr = pAssemblyImport->GetAssemblyFromScope(&mda);
    if (hr == CLDB_E_RECORD_NOTFOUND)
        return FALSE;
    else
	if (FAILED(hr))
	{
		TRACE(_T("Dziaanie GetAssemblyFromScope() nie powiodo si. 0x%0X8\n"), hr);
		return FALSE;
	}

    // Uzyskanie wymaganych wielkoci dla tablic wartoci, procesorw itp.
    ZeroMemory(&MetaData, sizeof(ASSEMBLYMETADATA));
    hr = pAssemblyImport->GetAssemblyProps(mda, 
                                           NULL, NULL,    // Public Key.
                                           NULL,          // Hash Algorithm.
                                           NULL, 0, NULL, // Name.
                                           &MetaData,
                                           NULL);         // Flags.
    if (FAILED(hr))
	{
		TRACE(_T("Dziaanie GetAssemblyProps() nie powiodo si. 0x%0X8"), hr);
		return FALSE;
	}
    // Alokacja przestrzeni dla tablic w strukturze ASSEMBLYMETADATA.
    if (MetaData.cbLocale)
        MetaData.szLocale = (WCHAR *)_alloca(sizeof(WCHAR) * MetaData.cbLocale);
    if (MetaData.ulProcessor)
        MetaData.rProcessor = (DWORD *)_alloca(sizeof(DWORD) * MetaData.ulProcessor);
    if (MetaData.ulOS)
        MetaData.rOS = (OSINFO *)_alloca(sizeof(OSINFO) * MetaData.ulOS);
    hr = pAssemblyImport->GetAssemblyProps(mda, 
                                          (const void **)&pbPublicKey, &cbPublicKey,
                                          &ulHashAlgId,
                                          szName, STRING_BUFFER_LEN, NULL,
                                          &MetaData,
                                          &dwFlags);
    if (FAILED(hr))
	{
		TRACE(_T("Dziaanie GetAssemblyProps() nie powiodo si. 0x%0X8"), hr);
		return FALSE;
	}

	CEdit *pText = (CEdit *)GetDlgItem(IDC_ASSEMBLYTOKEN);
	wsprintf(cBuffer, _T("0x%0X8"), mda);
	pText->SetWindowText(cBuffer);

	pText = (CEdit *)GetDlgItem(IDC_ASSEMBLYNAME);
	pText->SetWindowText(szName);

	pText = (CEdit *)GetDlgItem(IDC_ASSEMBLYPUBLICKEY);
	memset(cBuffer, 0, sizeof(cBuffer));
	int lines = cbPublicKey/16;
	for(int i = 0; i < lines; i++)
	{
		int bytesToPrint = ((i+1)*16 > cbPublicKey) ? (cbPublicKey - (i*16) + 1) : 16;
		for(int j = 0; j < bytesToPrint; j++)
		{
			wsprintf(tBuffer, L"0x%02X ", pbPublicKey[i*16 + j]);
			wcscat(cBuffer, tBuffer);
		}
		wcscat(cBuffer, L"\r\n");
	}
	pText->SetWindowText(cBuffer);

	pText = (CEdit *)GetDlgItem(IDC_ASSEMBLYHASHALGO);
	wsprintf(cBuffer, _T("0x%0X8"), ulHashAlgId);
	pText->SetWindowText(cBuffer);

	pAssemblyImport->Release();
	pAssemblyImport = NULL;
	pImport->Release();

	return TRUE;  // zwrcenie TRUE, chyba e ognisko ustawiono na element sterujcy
}
